IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Update_Movements_Without_Bed]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Update_Movements_Without_Bed]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author		:	PII
-- Created date	:	01/15/2013
-- Description	:	Updates admissions and movements without bed.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Update_Movements_Without_Bed] 
	@IEN VARCHAR(MAX),
	@VISTA_SITE_UID UNIQUEIDENTIFIER
AS
BEGIN
	SET NOCOUNT ON;

	CREATE TABLE #movements (NR INT, IEN VARCHAR(50), WARD_UID UNIQUEIDENTIFIER, BED_UID UNIQUEIDENTIFIER)
	INSERT INTO #movements 
		(NR, IEN, WARD_UID, BED_UID)
	SELECT ID, IEN, WARD_UID, BED_UID 
	FROM dbo.SPLIT_STRING_IEN_WARD_BED(@IEN, ',')
	
	DECLARE @I INT, @MAX INT, @tmpIEN VARCHAR(50), @tmpWARD UNIQUEIDENTIFIER, @tmpBED UNIQUEIDENTIFIER, @ID INT, @ID2 INT,
			@ADM_ID INT, @DIS_ID INT, @MOVEMENT_DATE DATETIME
			
	SELECT @MAX = COUNT(NR) FROM #movements
	SET @I = 1
	WHILE (@I <= @MAX) 
		BEGIN
			SELECT @tmpIEN = IEN, @tmpWARD = WARD_UID, @tmpBED = BED_UID FROM #movements WHERE NR = @I			
			SELECT @ID = ID, @ADM_ID = ADMISSION_ID, @MOVEMENT_DATE = MOVEMENT_DATE FROM MOVEMENT_EVN WHERE IEN = @tmpIEN AND VISTA_SITE_UID = @VISTA_SITE_UID
			IF (@ID IS NOT NULL)
				BEGIN
					UPDATE MOVEMENT_EVN
						SET WARD_UID = @tmpWARD,
							BED_UID = @tmpBED 
						WHERE ID = @ID
					SELECT TOP 1 @ID2 = ID FROM MOVEMENT_EVN WHERE ADMISSION_ID = @ADM_ID AND MOVEMENT_DATE > @MOVEMENT_DATE ORDER BY MOVEMENT_DATE
					IF (@ID2 IS NOT NULL)
						UPDATE MOVEMENT_EVN 
							SET OLD_WARD_UID = @tmpWARD, 
								OLD_BED_UID = @tmpBED 
							WHERE ID = @ID2
					ELSE
						BEGIN
							UPDATE ADMISSION_EVN 
								SET WARD_UID = @tmpWARD, 
									BED_UID = @tmpBED 
								WHERE ID = @ADM_ID
							SELECT @DIS_ID = ID FROM DISCHARGE_EVN WHERE ADMISSION_ID = @ADM_ID
							IF (@DIS_ID IS NOT NULL)
								UPDATE DISCHARGE_EVN
									SET WARD_UID = @tmpWARD, 
										BED_UID = @tmpBED
									WHERE ID = @DIS_ID
						END					
				END
			ELSE
				BEGIN
					SELECT @ID = ID FROM ADMISSION_EVN WHERE IEN = @tmpIEN AND VISTA_SITE_UID = @VISTA_SITE_UID
					IF (@ID IS NOT NULL)
						BEGIN							
							IF NOT EXISTS (SELECT ID FROM MOVEMENT_EVN WHERE ADMISSION_ID = @ID)
								BEGIN
									UPDATE ADMISSION_EVN
										SET WARD_UID = @tmpWARD,
											BED_UID = @tmpBED,
											INITIAL_WARD_UID = @tmpWARD,
											INITIAL_BED_UID = @tmpBED
										WHERE ID = @ID
									SELECT @DIS_ID = ID FROM DISCHARGE_EVN WHERE ADMISSION_ID = @ID
									IF (@DIS_ID IS NOT NULL)
										UPDATE DISCHARGE_EVN
											SET WARD_UID = @tmpWARD, 
												BED_UID = @tmpBED
											WHERE ID = @DIS_ID	
								END									
							ELSE
								BEGIN
									UPDATE ADMISSION_EVN
										SET INITIAL_WARD_UID = @tmpWARD,
											INITIAL_BED_UID = @tmpBED
										WHERE ID = @ID
									SELECT TOP 1 @ID2 = ID FROM MOVEMENT_EVN WHERE ADMISSION_ID = @ID ORDER BY MOVEMENT_DATE
									UPDATE MOVEMENT_EVN
										SET OLD_BED_UID = @tmpBED,
											OLD_WARD_UID = @tmpWARD
										WHERE ID = @ID2
								END
						END
				END
			SET @ID = NULL
			SET @ID2 = NULL
			SET @ADM_ID = NULL
			SET @DIS_ID = NULL
			SET @MOVEMENT_DATE = NULL
			SET @I = @I + 1
		END
	
	DROP TABLE #movements
	
END
GO